<?php
require '../config.php';
header('Content-Type: application/json');
$domain = $_POST['domain'] ?? '';
$headers = getallheaders();
$client_key = $headers['X-Client-Key'] ?? ($headers['x-client-key'] ?? '');
$signature  = $headers['X-Signature'] ?? ($headers['x-signature'] ?? '');
$timestamp  = $headers['X-Timestamp'] ?? ($headers['x-timestamp'] ?? '');

if(!$domain){ echo json_encode(['success'=>false,'message'=>'domain missing']); exit; }

$stmt = $pdo->prepare('SELECT * FROM user_domains WHERE domain = ?');
$stmt->execute([$domain]);
$row = $stmt->fetch();
if(!$row){ echo json_encode(['success'=>false,'message'=>'domain not registered']); exit; }

global $hmac_required, $hmac_ttl;
if($hmac_required){
    if(empty($client_key) || empty($signature) || empty($timestamp)){ echo json_encode(['success'=>false,'message'=>'missing auth headers']); exit; }
    if(abs(time() - intval($timestamp)) > intval($hmac_ttl)){ echo json_encode(['success'=>false,'message'=>'timestamp expired']); exit; }
    $stmt2 = $pdo->prepare('SELECT * FROM user_domains WHERE client_key = ?');
    $stmt2->execute([$client_key]);
    $r2 = $stmt2->fetch();
    if(!$r2){ echo json_encode(['success'=>false,'message'=>'invalid client key']); exit; }
    $expected = hash_hmac('sha256', $domain . $timestamp, $r2['client_secret']);
    if(!hash_equals($expected, $signature)){ file_put_contents(__DIR__ . '/../logs/failed_hmac.log', date('c') . " - bad_signature - domain={$domain}\n", FILE_APPEND); echo json_encode(['success'=>false,'message'=>'invalid signature']); exit; }
    if($r2['id'] != $row['id']){ echo json_encode(['success'=>false,'message'=>'domain/key mismatch']); exit; }
}

$u = $pdo->prepare('UPDATE user_domains SET status=?, connected_at=NOW() WHERE id=?');
$u->execute(['connected', $row['id']]);
// notify
$usr = $pdo->prepare('SELECT email FROM users WHERE id=?'); $usr->execute([$row['user_id']]); $user = $usr->fetch();
@send_telegram('🔗 <b>Domain Connected</b>\nUser: '.htmlspecialchars($user['email']).'\nDomain: '.htmlspecialchars($domain));
echo json_encode(['success'=>true,'message'=>'domain connected']);
?>