<?php
// clients can POST signed JSON to update config (HMAC)
require '../config.php';
header('Content-Type: application/json');
$headers = getallheaders();
$client_key = $headers['X-Client-Key'] ?? ($headers['x-client-key'] ?? '');
$signature  = $headers['X-Signature'] ?? ($headers['x-signature'] ?? '');
$timestamp  = $headers['X-Timestamp'] ?? ($headers['x-timestamp'] ?? '');
$body = file_get_contents('php://input');
$data = json_decode($body, true);
$domain = $data['domain'] ?? '';
if(!$domain){ echo json_encode(['success'=>false,'message'=>'domain missing']); exit; }
$stmt = $pdo->prepare('SELECT * FROM user_domains WHERE client_key=?'); $stmt->execute([$client_key]); $row=$stmt->fetch();
if(!$row){ echo json_encode(['success'=>false,'message'=>'invalid client key']); exit; }
global $hmac_required,$hmac_ttl; if($hmac_required){
    if(empty($signature) || empty($timestamp)){ echo json_encode(['success'=>false,'message'=>'missing auth headers']); exit; }
    if(abs(time()-intval($timestamp))>intval($hmac_ttl)){ echo json_encode(['success'=>false,'message'=>'timestamp expired']); exit; }
    $expected = hash_hmac('sha256', $domain . $timestamp, $row['client_secret']);
    if(!hash_equals($expected,$signature)){ file_put_contents(__DIR__ . '/../logs/failed_hmac.log', date('c') . " - bad_sig_update - domain={$domain}\n", FILE_APPEND); echo json_encode(['success'=>false,'message'=>'invalid signature']); exit; }
    if($row['domain'] !== $domain){ echo json_encode(['success'=>false,'message'=>'domain mismatch']); exit; }
}
$allowed=['telegram_bot_token','telegram_chat_id','email_result','smtp_host','smtp_port','smtp_user','smtp_pass','custom_json'];
$updated=[];
foreach($allowed as $k){ if(isset($data[$k])){ $enc=base64_encode($data[$k]); $up=$pdo->prepare('INSERT INTO domain_configs (domain_id,config_key,config_value) VALUES (?,?,?) ON DUPLICATE KEY UPDATE config_value=VALUES(config_value)'); $up->execute([$row['id'],$k,$enc]); $updated[]=$k; } }
@send_telegram('🧩 Config updated via API for domain '.htmlspecialchars($domain).' updated: '.implode(', ',$updated));
echo json_encode(['success'=>true,'updated'=>$updated]);
?>