<?php
// Basic config - edit or use installer
date_default_timezone_set('Asia/Jakarta');
$db_host = '127.0.0.1';
$db_name = 'glitch_system';
$db_user = 'root';
$db_pass = '';

$base_url = 'http://localhost/glitch-official-v4-lite'; // adjust

// Telegram owner bot (global) for notifications (optional)
$telegram_bot_token = '';
$telegram_chat_id = '';

// HMAC settings
$hmac_required = true;
$hmac_ttl = 300; // seconds

try {
    $pdo = new PDO("mysql:host={$db_host};dbname={$db_name};charset=utf8mb4", $db_user, $db_pass, [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (Exception $e) {
    die('DB connection failed: ' . $e->getMessage());
}

session_start();

function send_telegram($message){
    global $telegram_bot_token, $telegram_chat_id;
    if(empty($telegram_bot_token) || empty($telegram_chat_id)) return false;
    @file_get_contents('https://api.telegram.org/bot' . $telegram_bot_token . '/sendMessage?' . http_build_query(['chat_id'=>$telegram_chat_id,'text'=>$message,'parse_mode'=>'HTML']));
    return true;
}
?>