<?php
require '../functions.php';
require_login();
$user_id=$_SESSION['user_id']; $msg='';
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['connect_domain'])){
    $domain=trim($_POST['domain']);
    if($domain){
        $stmt=$pdo->prepare('SELECT id FROM user_domains WHERE domain=?'); $stmt->execute([$domain]);
        if($stmt->fetch()) $msg='Domain exists';
        else {
            $client_key=bin2hex(random_bytes(8)); $client_secret=bin2hex(random_bytes(24));
            $stmt=$pdo->prepare('INSERT INTO user_domains (user_id,domain,status,client_key,client_secret) VALUES (?,?,?,?,?)');
            $stmt->execute([$user_id,$domain,'pending',$client_key,$client_secret]); $msg='Domain added. Place client script to verify.';
        }
    }
}
$stmt=$pdo->prepare('SELECT * FROM user_domains WHERE user_id=?'); $stmt->execute([$user_id]); $domains=$stmt->fetchAll();
?>
<!doctype html><html><head><meta charset="utf-8"><title>Configurasi</title><link rel="stylesheet" href="../assets/css/glitch.css"></head><body>
<nav class="topbar"><a href="index.php" class="glitch-text">Dashboard</a> | <a href="system_settings.php">System Settings</a></nav>
<main class="center"><h2>Configurasi</h2><?php if($msg) echo '<p class="info">'.htmlspecialchars($msg).'</p>'; ?>
<form method="post"><input name="domain" placeholder="example.com" required><button name="connect_domain">Connect Domain</button></form>
<h3>Your Domains</h3><table><tr><th>Domain</th><th>Status</th><th>Client Key</th><th>Client Secret</th><th>Connected At</th></tr>
<?php foreach($domains as $d): ?><tr><td><?=htmlspecialchars($d['domain'])?></td><td><?=htmlspecialchars($d['status'])?></td><td><?=htmlspecialchars($d['client_key'])?></td><td><small><?=htmlspecialchars($d['client_secret'])?></small></td><td><?=htmlspecialchars($d['connected_at'])?></td></tr><?php endforeach; ?>
</table><h3>Client Examples</h3><pre>&lt;?php include '../client/connect.php'; ?&gt;</pre></main></body></html>
