<?php
require '../functions.php';
require_login();
$user_id=$_SESSION['user_id'];
// load connected domains for this user
$stmt=$pdo->prepare('SELECT * FROM user_domains WHERE user_id=? AND status=?'); $stmt->execute([$user_id,'connected']); $domains=$stmt->fetchAll();
$msg='';
if($_SERVER['REQUEST_METHOD']==='POST' && isset($_POST['save'])){
    $domain_id=intval($_POST['domain_id']);
    // verify ownership
    $s=$pdo->prepare('SELECT id FROM user_domains WHERE id=? AND user_id=?'); $s->execute([$domain_id,$user_id]);
    if(!$s->fetch()) $msg='Unauthorized';
    else {
        $keys=['telegram_bot_token','telegram_chat_id','email_result','smtp_host','smtp_port','smtp_user','smtp_pass','custom_json'];
        foreach($keys as $k){
            $v = $_POST[$k] ?? '';
            $enc = base64_encode($v);
            $up=$pdo->prepare('INSERT INTO domain_configs (domain_id,config_key,config_value) VALUES (?,?,?) ON DUPLICATE KEY UPDATE config_value=VALUES(config_value)');
            $up->execute([$domain_id,$k,$enc]);
        }
        $msg='Saved';
        @send_telegram('🧩 Config updated for domain id ' . $domain_id);
    }
}
function load_conf($pdo,$domain_id){ $s=$pdo->prepare('SELECT config_key,config_value FROM domain_configs WHERE domain_id=?'); $s->execute([$domain_id]); $rows=$s->fetchAll(); $out=[]; foreach($rows as $r){ $out[$r['config_key']]=base64_decode($r['config_value']); } return $out; }
?>
<!doctype html><html><head><meta charset="utf-8"><title>System Settings</title><link rel="stylesheet" href="../assets/css/glitch.css"></head><body>
<nav class="topbar"><a href="index.php" class="glitch-text">Dashboard</a> | <a href="configurasi.php">Configurasi</a></nav>
<main class="center"><h2>System Settings</h2><?php if($msg) echo '<p class="info">'.htmlspecialchars($msg).'</p>'; ?>
<?php if(empty($domains)): ?><p class="info">No connected domains yet.</p><?php else: ?>
<form method="post"><label>Domain<select name="domain_id" id="domain_id" onchange="loadConfig()"><?php foreach($domains as $dom){ echo '<option value="'.intval($dom['id']).'">'.htmlspecialchars($dom['domain']).'</option>'; } ?></select></label>
<div id="fields"><?php $first_id=$domains[0]['id']; $cfg=load_conf($pdo,$first_id); $defaults=['telegram_bot_token','telegram_chat_id','email_result','smtp_host','smtp_port','smtp_user','smtp_pass','custom_json']; foreach($defaults as $k){ $v=$cfg[$k]??''; echo '<label>'.htmlspecialchars($k).'<input name="'.$k.'" value="'.htmlspecialchars($v).'"></label>'; } ?></div>
<button name="save" type="submit">Save</button></form>
<script>function loadConfig(){ var id=document.getElementById('domain_id').value; fetch('system_settings_load.php?domain_id='+id).then(r=>r.json()).then(j=>{ const keys=['telegram_bot_token','telegram_chat_id','email_result','smtp_host','smtp_port','smtp_user','smtp_pass','custom_json']; let html=''; keys.forEach(k=>{ html += '<label>'+k+'<input name="'+k+'" value="'+(j[k]||'')+'"></label>'; }); document.getElementById('fields').innerHTML=html; }); }</nscript>
<?php endif; ?></main></body></html>
