-- DB for glitch-official-v4-lite
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    email VARCHAR(150) UNIQUE,
    password VARCHAR(255),
    api_key VARCHAR(64),
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE user_domains (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT,
    domain VARCHAR(255),
    status ENUM('connected','pending','suspended') DEFAULT 'pending',
    client_key VARCHAR(64) DEFAULT NULL,
    client_secret VARCHAR(128) DEFAULT NULL,
    connected_at TIMESTAMP NULL,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);

CREATE TABLE domain_configs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    domain_id INT,
    config_key VARCHAR(100),
    config_value TEXT,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE(domain_id, config_key),
    FOREIGN KEY (domain_id) REFERENCES user_domains(id) ON DELETE CASCADE
);
